version 14
#delimit;
log using "R:\Gagnon\Asia New Mediocre\Asia Phillips Japan.txt", replace text;
clear;
clear mata;
clear matrix;
set more off;
*set maxvar 32767, permanently;
cd "R:\Gagnon\Asia New Mediocre";

/*
import excel "R:\Gagnon\Asia New Mediocre\Phillips Japan 20171121.xlsx", sheet("Sheet1") firstrow clear;
gen double time = monthly(month, "YM");
format time %tm;
sort time;
tsset time;

*Fill in lagged inflation from 1997 IFS Yearbook based on overall CPI annual data;
replace dcpixfext = 5.5 if time>=tm(1968m1)&time<=tm(1968m12);
replace dcpixfext = 5.2 if time>=tm(1969m1)&time<=tm(1969m12);
replace dcpixfext = 7.8 if time>=tm(1970m1)&time<=tm(1970m12);
tssmooth ma dcpixfextma = dcpixfext, w(35 1 0);
replace dcpixfextma = . if L35.dcpixfext==.;
gen ddcpixfext = dcpixfext-L12.dcpixfext;
gen ddcpixfextma = dcpixfext-L12.dcpixfextma;

tssmooth ma dwagema36 = dwage, w(35 1 0);
tssmooth ma dwagema3 = dwage, w(2 1 0);
replace dwagema36 = . if L35.dwage==.;
gen ddwagema = dwagema3-L12.dwagema36;

gen nairux = 2 if time==tm(1982m1);
*gen nairux = 1.5 if time==tm(1970m1);
*replace nairux = 3 if time==tm(2017m9);
replace nairux = 3 if time==tm(2015m1);
ipolate nairux time, gen(nairu);
replace nairu = 3 if time>tm(2015m1);
gen gap = nairu-unemp;

*scatter ddcpixfextma L12.gap if L12.dcpixfext>3, xtitle("Employment Gap") ytitle("Change in Inflation") 
*        title("Inflation > 3%") xline(0) yline(0) mcolor(gs11) saving(Japanhigh3.gph, replace);
*scatter ddcpixfextma L12.gap if L12.dcpixfext<3, xtitle("Employment Gap") ytitle("Change in Inflation") 
*        title("Inflation < 3%") xline(0) yline(0) mcolor(gs11) ttext(-0.65 -0.03 "2017M9", color(black) size(small)) 
*		saving(Japanlow3.gph, replace);
*scatter ddcpixfextma L12.gap if L12.dcpixfext>2, xtitle("Employment Gap") ytitle("Change in Inflation") 
*        title("Inflation > 2%") xline(0) yline(0) mcolor(gs11) saving(Japanhigh2.gph, replace);
*scatter ddcpixfextma L12.gap if L12.dcpixfext<2, xtitle("Employment Gap") ytitle("Change in Inflation") 
*        title("Inflation < 2%") xline(0) yline(0) mcolor(gs11) ttext(-0.65 -0.03 "2017M9", color(black) size(small)) 
*		saving(Japanlow2.gph, replace);
scatter ddcpixfextma L12.gap if L12.dcpixfext>1&time>=tm(1982m1), xtitle("Employment Gap") ytitle("Change in Inflation") 
        title("Inflation > 1%") xline(0) yline(0) mcolor(gs11) saving(Japanhigh11982.gph, replace);
scatter ddcpixfextma L12.gap if L12.dcpixfext<1&time>=tm(1982m1), xtitle("Employment Gap") ytitle("Change in Inflation") 
        title("Inflation < 1%") xline(0) yline(0) mcolor(gs11) ttext(-0.65 -0.03 "2017M9", color(black) size(small)) 
		saving(Japanlow11982.gph, replace);
scatter ddwagema L12.gap if L12.dwagema3>2&time>=tm(1982m1), xtitle("Employment Gap") ytitle("Change in Earnings Growth") 
        title("Earnings Growth > 2%") xline(0) yline(0) mcolor(gs11) saving(Japanhigh11982wage.gph, replace);
scatter ddwagema L12.gap if L12.dwagema3<2&time>=tm(1982m1), xtitle("Employment Gap") ytitle("Change in Earnings Growth") 
        title("Earnings Growth < 2%") xline(0) yline(0) mcolor(gs11) ttext(-0.65 -0.03 "2017M9", color(black) size(small)) 
		saving(Japanlow11982wage.gph, replace);
			
*graph combine Japanlow3.gph Japanhigh3.gph, rows(1) ycommon xcommon saving(JapanblogPC3, replace);
*graph combine Japanlow1.gph Japanhigh1.gph, rows(1) ycommon xcommon saving(JapanblogPC1, replace);
graph combine Japanlow11982.gph Japanhigh11982.gph, rows(1) ycommon xcommon saving(JapanblogPC11982, replace);
graph combine Japanlow11982wage.gph Japanhigh11982wage.gph, rows(1) ycommon xcommon saving(JapanblogPC11982wage, replace);

label variable nairu "Assumed Natural Rate";
label variable unemp "Unemployment Rate";
label variable dcpixfext "Core Inflation Rate"; 
label variable dwage "Change in Earnings";
line unemp nairu time if time>=tm(1982m1), ttitle("") tlab(1985m1(120)2015m1) lpa(solid dash) saving(Japannairu.gph, replace);
line dcpixfext time if time>=tm(1982m1), ttitle("") ytitle("") legend(on) tlab(1985m1(120)2015m1) saving(Japancorecpi.gph, replace);
line dwage time if time>=tm(1982m1), ttitle("") ytitle("") legend(on) tlab(1985m1(120)2015m1) saving(Japanwage.gph, replace);
graph combine Japancorecpi.gph Japannairu.gph, rows(2) xcommon saving(Japanblogmacro, replace);
graph combine Japanwage.gph Japannairu.gph, rows(2) xcommon saving(Japanblogmacrowage, replace);

scatter ddcpixfextma L12.gap if L12.dcpixfext>1&time>=tm(1982m1), xtitle("Employment Gap") ytitle("Change in Inflation") 
        title("Inflation > 1%") xline(0) yline(0) m(i) mlab(time) mlabp(0) mlabsize(vsmall) saving(Japanhigh1text.gph, replace);
*/

/*
scatter ddcpixfextma L12.caputil if L12.dcpixfext>2, xtitle("Capacity Utilization") ytitle("Change in Inflation") 
        title("Inflation > 2%") yline(0) mcolor(gs11) saving(Japancuhigh2.gph, replace);
scatter ddcpixfextma L12.caputil if L12.dcpixfext<2, xtitle("Capacity Utilization") ytitle("Change in Inflation") 
        title("Inflation < 2%") yline(0) mcolor(gs11) ttext(-0.65 97.6 "2017M9", color(black) size(small)) 
		saving(Japanculow2.gph, replace);
graph combine Japanculow2.gph Japancuhigh2.gph, rows(1) ycommon xcommon saving(JapanblogcuPC2, replace);

gen cugap = caputil-120;
replace cugap = caputil-100 if time>=tm(2009m1);
scatter ddcpixfextma L12.cugap if L12.dcpixfext>2, xtitle("CU Gap") ytitle("Change in Inflation") 
        title("Inflation > 2%") xline(0) yline(0) mcolor(gs11) saving(Japancugaphigh2.gph, replace);
scatter ddcpixfextma L12.cugap if L12.dcpixfext<2, xtitle("CU Gap") ytitle("Change in Inflation") 
        title("Inflation < 2%") xline(0) yline(0) mcolor(gs11) ttext(-0.65 -2.4 "2017M9", color(black) size(small)) 
		saving(Japancugaplow2.gph, replace);
graph combine Japancugaplow2.gph Japancugaphigh2.gph, rows(1) ycommon xcommon saving(JapanblogcugapPC2, replace);
*/


import excel "R:\Gagnon\Asia New Mediocre\Japan 20171121.xlsx", sheet("Haver") firstrow clear;
gen double time = quarterly(quarter, "YQ");
format time %tq;
sort time;
tsset time;

gen dcpixfe = 100*(cpixfe-L4.cpixfe)/L4.cpixfe;
gen tax = 0;
replace tax = (dcpixfe+F3.dcpixfe-L1.dcpixfe-F4.dcpixfe)/2 if time==tq(1997q2);
replace tax = (L1.dcpixfe+F2.dcpixfe-L2.dcpixfe-F3.dcpixfe)/2 if time==tq(1997q3);
replace tax = (L2.dcpixfe+F1.dcpixfe-L3.dcpixfe-F2.dcpixfe)/2 if time==tq(1997q4);
replace tax = (L3.dcpixfe+dcpixfe-L4.dcpixfe-F1.dcpixfe)/2 if time==tq(1998q1);
replace tax = (dcpixfe+F3.dcpixfe-L1.dcpixfe-F4.dcpixfe)/2 if time==tq(2014q2);
replace tax = (L1.dcpixfe+F2.dcpixfe-L2.dcpixfe-F3.dcpixfe)/2 if time==tq(2014q3);
replace tax = (L2.dcpixfe+F1.dcpixfe-L3.dcpixfe-F2.dcpixfe)/2 if time==tq(2014q4);
replace tax = (L3.dcpixfe+dcpixfe-L4.dcpixfe-F1.dcpixfe)/2 if time==tq(2015q1);
gen dcpixfext = dcpixfe-tax;

*Fill in lagged inflation from 1997 IFS Yearbook based on overall CPI annual data;
replace dcpixfext = 5.5 if time>=tq(1968q1)&time<=tq(1968q4);
replace dcpixfext = 5.2 if time>=tq(1969q1)&time<=tq(1969q4);
replace dcpixfext = 7.8 if time>=tq(1970q1)&time<=tq(1970q4);
tssmooth ma dcpixfextma = dcpixfext, w(11 1 0);
replace dcpixfextma = . if L11.dcpixfext==.;
gen ddcpixfext = dcpixfext-L4.dcpixfext;
gen ddcpixfextma = dcpixfext-L4.dcpixfextma;
tssmooth ma dulcma = dulc, w(11 1 0);
replace dulcma = . if L11.dulc==.;
gen ddulcma = dulc-L4.dulcma;

*Fill in lagged inflation for bojcore measure using cpixfext;
replace bojcore = dcpixfext if time<tq(1986q1);
tssmooth ma bojcorema = bojcore, w(11 1 0);
replace bojcorema = . if L11.bojcore==.;
gen dbojcorema = bojcore - L4.bojcorema;

*Add speed limit effect;
gen gap2 = gap + D.gap/2;

*Create NAIRU;
gen nairux = 2.5 if time==tq(1982q1);
replace nairux = 3 if time==tq(2016q3);
ipolate nairux time, gen(nairu);
replace nairu = 3 if time>tq(2016q3);
*gen nairu = 3;
gen ugap = nairu-unemp;

*scatter ddcpixfextma L4.gap2 if L4.dcpixfext>1&time>=tq(1984q1), ylab(-4(2)4) xtitle("Output Gap") ytitle("Change in Inflation") 
*        title("Inflation > 1%") xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) saving(Japanhighq2.gph, replace);
*scatter ddcpixfextma L4.gap2 if L4.dcpixfext<1&time>=tq(1984q1), ylab(-4(2)4) xtitle("Output Gap") ytitle("Change in Inflation") 
*        title("Inflation < 1%") xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) ttext(-0.68 0.4 "2017Q3", color(black) size(small)) 
*		saving(Japanlowq2.gph, replace);
*scatter ddcpixfextma L4.gap if L4.dcpixfext>1&time>=tq(1984q1), ylab(-3(1)3) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
*        title("Inflation > 1%") xlab(-6(2)6) xsc(r(-7 7)) xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) saving(Japanhighq1.gph, replace);
*scatter ddcpixfextma L4.gap if L4.dcpixfext<1&time>=tq(1984q1), ylab(-3(1)3) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
*        title("Inflation < 1%") xlab(-6(2)6) xsc(r(-7 7)) xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) ttext(-0.68 -0.02 "2017Q3", color(black) size(small)) 
*		saving(Japanlowq1.gph, replace);
scatter ddcpixfextma L4.gap if time>=tq(1982q1)&time<tq(1995q1), ylab(-2(1)2) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
        title("1984-94") xlab(-4(2)6) xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) saving(Japanhighq1.gph, replace);
scatter ddcpixfextma L4.gap if time>=tq(1995q1), ylab(-2(1)2) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
        title("1995-2017") xlab(-6(2)4) xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) 
		ttext(-0.68 -0.02 "2017Q3", color(black) size(small)) saving(Japanlowq1.gph, replace);
*scatter dbojcorema L4.gap if L4.bojcore>1&time>=tq(1984q1), ylab(-3(1)3) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
*        title("Inflation > 1%") xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) saving(Japanhighcoreq1.gph, replace);
*scatter dbojcorema L4.gap if L4.bojcore<1&time>=tq(1984q1), ylab(-3(1)3) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
*        title("Inflation < 1%") xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) ttext(0.01 -0.02 "2017Q3", color(black) size(small)) 
*		saving(Japanlowcoreq1.gph, replace);
*scatter ddulcma L4.ugap if L4.dulc>1&time>=tq(1982q1), xtitle("Employment Gap") ytitle("Change in Labor Cost Growth") 
*        title("Cost Growth > 1%") xlab(-3(1)1) xline(0) yline(0) mcolor(gs11) saving(Japanhighq1un.gph, replace);
*scatter ddulcma L4.ugap if L4.dulc<1&time>=tq(1982q1), xtitle("Employment Gap") ytitle("Change in Labor Cost Growth") 
*        title("Cost Growth < 1%") xlab(-3(1)1) xline(0) yline(0) mcolor(gs11) ttext(-0.35 0 "2017Q3", color(black) size(small)) 
*		saving(Japanlowq1un.gph, replace);
scatter ddulcma L4.ugap if time<tq(1995q1), xtitle("Employment Gap") ytitle("Change in Labor Cost Growth") 
        title("1984-94") xlab(-1(1)1) xline(0) yline(0) mcolor(gs11) saving(Japanhighq1un.gph, replace);
scatter ddulcma L4.ugap if time>=tq(1995q1), xtitle("Employment Gap") ytitle("Change in Labor Cost Growth") 
        title("1995-2017") xlab(-3(1)0) xline(0) yline(0) mcolor(gs11) ttext(-0.35 0 "2017Q3", color(black) size(small)) 
		saving(Japanlowq1un.gph, replace);
		
*graph combine Japanlowq2.gph Japanhighq2.gph, rows(1) ycommon xcommon saving(JapanblogPCq2, replace);
graph combine Japanhighq1.gph Japanlowq1.gph, rows(1) ycommon saving(JapanblogPCq1, replace);
*graph combine Japanlowcoreq1.gph Japanhighcoreq1.gph, rows(1) ycommon xcommon saving(JapanblogcorePCq1, replace);
graph combine Japanhighq1un.gph Japanlowq1un.gph, rows(1) ycommon saving(JapanblogPCq1un, replace);

*scatter ddcpixfextma L4.gap2 if time>=tq(1984q1), ylab(-3(1)3) xtitle("Adjusted Output Gap") ytitle("Change in Inflation") 
*        xline(0) yline(0) mcolor(gs11) ttext(-0.68 -1.9 "2017Q3", color(black) size(small)) 
*		saving(JapanPC2q.gph, replace);
*scatter ddcpixfextma L4.gap if time>=tq(1984q1), ylab(-3(1)3) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
*        xline(0) xline(2, lpa(dash)) yline(0) mcolor(gs11) ttext(-0.68 0.1 "2017Q3", color(black) size(small)) 
*		saving(JapanPCq.gph, replace);

label variable gap "Bank of Japan output gap, percent";
label variable dcpixfext "Inflation rate, ex. food, energy & tax, 4-qtr. percent change";
label variable ugap "Employment gap";
label variable dulc "Growth of unit labor cost, 4-qtr. percent change";
label variable unemp "Unemployment rate, percent of labor force";
label variable nairu "Assumed natural rate";

line gap time if time>=tq(1983q1), ttitle("") ytitle("") tlab(1985q1(40)2015q1) legend(on) yline(0) saving(Japangapq.gph, replace);
line dcpixfext time if time>=tq(1983q1), ttitle("") ytitle("") tlab(1985q1(40)2015q1) legend(on) yline(0) saving(Japandcpixcextq.gph, replace);
graph combine Japandcpixcextq.gph Japangapq.gph, rows(2) xcommon saving(Japanblogmacroq, replace);
line unemp nairu time if time>=tq(1982q1), ttitle("") ytitle("") lpa(solid dash) 
     tlab(1985q1(40)2015q1) legend(on) saving(Japanugapq.gph, replace);
line dulc time if time>=tq(1982q1), ttitle("") ytitle("") tlab(1985q1(40)2015q1) legend(on) yline(0) saving(Japandulcq.gph, replace);
graph combine Japandulcq.gph Japanugapq.gph, rows(2) xcommon saving(Japanblogmacroqun, replace);

reg ddulcma L4.ugap if time<tq(1995q1);
newey ddulcma L4.ugap if time<tq(1995q1), lag(3);
reg ddulcma L4.ugap if time>=tq(1995q1);
newey ddulcma L4.ugap if time>=tq(1995q1), lag(3);
reg ddcpixfextma L4.gap if time<tq(1995q1);
newey ddcpixfextma L4.gap if time<tq(1995q1), lag(3);
reg ddcpixfextma L4.gap if time>=tq(1995q1);
newey ddcpixfextma L4.gap if time>=tq(1995q1), lag(3);

reg ddulcma ugap if time<tq(1995q1);
newey ddulcma ugap if time<tq(1995q1), lag(3);
reg ddulcma ugap if time>=tq(1995q1);
newey ddulcma ugap if time>=tq(1995q1), lag(3);
reg ddcpixfextma gap if time<tq(1995q1);
newey ddcpixfextma gap if time<tq(1995q1), lag(3);
reg ddcpixfextma gap if time>=tq(1995q1);
newey ddcpixfextma gap if time>=tq(1995q1), lag(3);

/*	
scatter ddcpixfextma gap if L4.dcpixfext<1&time>=tq(1984q1), ylab(-3(1)3) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
        xline(0) xline(2, lpa(dash)) yline(0) m(i) mlab(time) mlabp(0) mlabsize(vsmall) 
		saving(JapanPCqlablow.gph, replace);
scatter ddcpixfextma gap if L4.dcpixfext>1&time>=tq(1984q1), ylab(-3(1)3) xtitle("Bank of Japan Output Gap") ytitle("Change in Inflation") 
        xline(0) xline(2, lpa(dash)) yline(0) m(i) mlab(time) mlabp(0) mlabsize(vsmall) 
		saving(JapanPCqlabhigh.gph, replace);
graph combine JapanPCqlablow.gph JapanPCqlabhigh.gph, rows(1) ycommon xcommon saving(JapanblogPCqlab, replace);
*/
		
log close;









 


